% CI Engine Cold-to-Hot Fuel Use and Emissions Comparison
% 
% 

 

<center>
**<font size="+2">Updating ADVISOR’s CI Engine Cold-to-Hot Fuel Use and
Emissions Predictions Based on ORNL’s Test Data on VW 1.9L and Mercedes
1.7L Engines</font>**

<p>
January 2001

</center>
[Introduction](#intro) \
[Experimental Cold-to-Hot Correction Factors](#expt)

> [Fuel Use](#fuel) \
> [HC](#hc) \
> [CO](#co) \
> [NOx](#nox) \
> [PM](#pm)

[Conclusions](#conclusions) \
[New ADVISOR Cold-to-Hot Engine Map Correction
Factors](#new%20ADV%20corr%20factors)

> [Option 1: Change the values of ADVISOR’s Cold-Hot Adjustment
> Factors](#op1) \
> [Option 2: Correction Factors as Functions of Speed and Torque, in
> addition to Temperature through <font face="Symbol">l, </font>Map Fits
> Based on Trends](#op2) \
> [Option 3: Cold Maps Input by User](#op3)

\
<a name="intro"></a>**Introduction**

Previous ADVISOR cold-to-hot engine fuel and emissions penalties are
based on data generated by Dill Murrell in 1994. This testing covered SI
engines, and was extrapolated based on vehicle performance over cycles
(e.g. FTP). The penalties are determined by the following equations.

<p>
Equation 1 defines a normalized temperature factor
(<font face="Symbol">l</font>) related to the thermostat set point of
the coolant (*fc\_tstat*) and the dynamic coolant temperature
(*T~coolant~*).

<center>
<p>
![](Image89.gif) Eqn 1

</center>
where temperatures are in degrees C. For example, if the coolant
temperature were 20<font face="Symbol">°</font> C (cold engine),
<font face="Symbol">l</font> would be 1, and if the engine were at the
set point of 95<font face="Symbol">°</font> C (hot engine),
<font face="Symbol">l</font> would be zero.

<p>
The fuel and emissions are then computed by the following equation:

<center>
<p>
![](Image90.gif) Eqn 2

</center>
Dill Murrell did not perform experiments on a CI engine, so there was no
experimental curve fit available for PM. Therefore, PM was assumed to
have the same characteristics as HC.

These correction factors were applied across the entire torque-speed map
for each of the five variables of interest in Equation 2. This constant
factor approach introduced significant error, as the ratio of
cold-to-hot usage varied throughout a given map.

Data collected at Oak Ridge National Laboratory on two CI engines showed
discrepancies between ADVISOR’s current cold-to-hot correction factors
and actual operating conditions. This data also created previously
unknown PM correction factors for ADVISOR.

<a name="expt"></a>**Experimental Cold-to-Hot Correction Factors**

ORNL produced steady-state engine maps (fuel use, HC, CO, NOx, PM) for
two engines over two scenarios: 1) a hot engine, and 2) an engine that
was force cooled with water. ). The experiments were performed on a
Volkswagen 1.9L TDI diesel engine and a Mercedes A 1.7L diesel engine.
The VW engine was held at 21.1<font face="Symbol">°</font> C
(70<font face="Symbol">°</font> F) for scenario 2 (cold), and the
Mercedes engine was held at 32.2<font face="Symbol">°</font> C
(90<font face="Symbol">°</font> F). With an assumed typical coolant set
point of 95<font face="Symbol">°</font> C, ADVISOR’s normalized
temperature, <font face="Symbol">l</font>, was 0.985 for VW and 0.837
for Mercedes (see Equation 1). For convenience, the Volkswagen engine
will be noted by VW and the Mercedes engine will be noted by MB.

For the VW engine, force-cooled data was taken over the entire map
(800-4400 rpm). For the MB engine, cold data was taken only over the low
speed region (1200-2800 rpm). To keep the map in context, the MB graphs
have an x axis which corresponds to the entire engine operating region
(1200-4200 rpm).

The current predictions by ADVISOR are shown at the top of each graph
presented below.

<a name="fuel"></a><u>Fuel Use</u>

<p>
ADVISOR predicts a cold-to-hot factor of 1.95 (VW) and 1.58 (MB). Figure
1 shows that for most of the fuel use map, the ratio does not exceed 1.
Only at very low torque outputs does the fuel use increase; the maximum
increase is \~30%. Figure 2 shows that for high torques, the cold
penalty is \~3%, and for low torques the penalty can again reach 30%.
Therefore, ADVISOR is currently over predicting fuel use at cold
temperatures.

<center>
![](Image91.gif)

<a name="_Ref465505016"></a>**Figure 1: VW Fuel Use Cold to Hot Ratio**

![](Image92.gif)

<p>
<a name="_Ref505497730"></a>**Figure 2: Mercedes Fuel Use Cold to Hot
Ratio**

</center>
<a name="hc"></a><u>HC</u>

<p>
ADVISOR predicts cold-to-hot factors of 8.07 (VW) and 5.3 (MB). Figure 3
shows that for a large range on the HC map, the ratio is 1, i.e. no
additional emissions over the hot levels are expected when the engine is
cold. However, the HC map has an island near 2800 rpm and 150 Nm where
up to 30 X the hot emissions were seen. At low torque outputs, the ratio
also increased up to 50 X. The MB map shows less sensitivity to
temperature (Figure 4), as the ratio was 1.25-2 for high torques and 4X
for low speed-low torque combinations. In comparison to the current
ratio of 8 (VW), ADVISOR could be over or under predicting HC emissions,
depending on where in the map the engine was operating. On the MB
engine, ADVISOR is over-predicting HC emissions.

<center>
![](Image93.gif)

<a name="_Ref465505171"></a>**Figure 3: VW HC Cold to Hot Ratio**

![](Image94.gif)

<p>
<a name="_Ref505498897"></a>**Figure 4: Mercedes HC Cold to Hot Ratio**

</center>
<a name="co"></a><u>CO</u>

<p>
ADVISOR predicts cold-to-hot factors of 9.96 (VW) and 6.3 (MB). Figure 5
and Figure 6 show that this is over predicting cold CO emissions. For
VW, the maximum ratio reached at low torque outputs was near 7, with a
large section lying near 3. For MB, the maximum was near 3.5 with a
large area near 1.25. For most of the VW map, the ratio is lower than
one. This means that emissions at cold temperatures were lower than
emissions at high temperatures. This behavior is counter-intuitive, but
could have many causes, including: 1) experimental error, and 2) that
the behavior observed is real, and that CO emissions are lower at colder
temperatures at high speed/torque ranges.

<center>
![](Image95.gif)

<a name="_Ref465506844"></a>**Figure 5: VW CO Cold to Hot Ratio**

![](Image96.gif)

<p>
<a name="_Ref505504662"></a>**Figure 6: Mercedes CO Cold to Hot Ratio**

</center>
<a name="nox"></a><u>NOx</u>

<p>
ADVISOR predicts cold-to-hot factors of 1.54 (VW) and 1.16 (MB). For a
large section of the map, Figure 7 shows that ADVISOR is over-predicting
NOx emissions. However, at low torque-speed points, the ratio reached a
maximum near 2.5. As with the CO map, the VW ratio is less than one for
speeds above \~2000 rpm, though data was not available for this area of
the MB map. Figure 7 shows that NOx emissions are substantially lower
(0.25X) than hot emissions at high speeds. For the MB map in Figure 8,
ADVISOR’s prediction is close to observed behavior.

<center>
![](Image97.gif)

<a name="_Ref465507757"></a>**Figure 7: VW NOx Cold to Hot Ratio**

![](Image98.gif)

<p>
<a name="_Ref505505018"></a>**Figure 8: Mercedes NOx Cold to Hot Ratio**

</center>
<a name="pm"></a><u>PM</u>

<p>
ADVISOR predicts cold-to-hot factors of 8.07 (VW) and 5.3 (MB). This was
based on the assumption that the PM emissions responded in the same
manner as the HC emissions, as data was previously unavailable. Figure 9
and Figure 10 show that ADVISOR is over predicting PM emissions at low
temperatures, as most of the VW map does not show any increase in PM
with temperature and the MB map shows a factor ranging from 1-2X.
However, the VW map in the low speed/low torque range shows PM emissions
increase drastically, with ratios reaching 20 X.

<center>
![](Image99.gif)

<a name="_Ref465507946"></a>**Figure 9: VW PM Cold to Hot Ratio**

![](Image100.gif)

<p>
<a name="_Ref505505219"></a>**Figure 10: Mercedes PM Cold to Hot Ratio**

</center>
<u>Exhaust Temperature</u>

<p>
ADVISOR does not currently predict a cold-to-hot factor for exhaust
temperature. Figure 11 and Figure 12 confirm this omission, as the ratio
over most of the map is 1.

<center>
![](Image101.gif)

<a name="_Ref465508054"></a>**Figure 11: VW Exhaust Temperature Cold to
Hot Ratio**

![](Image102.gif)

<p>
<a name="_Ref505505347"></a>**Figure 12: Mercedes Exhaust Temperature
Cold to Hot Ratio**

</center>
<u>Exhaust Flow</u>

<p>
ADVISOR does not currently predict a cold-to-hot factor for exhaust
flow. Figure 13 and Figure 14 again mostly confirm this, as the ratio is
near 1.

<center>
![](Image103.gif)

<a name="_Ref465508103"></a>**Figure 13: Exhaust Flow Cold to Hot
Ratio**

![](Image104.gif)

<p>
<a name="_Ref505505386"></a>**Figure 14: Mercedes Exhaust Flow Cold to
Hot Ratio**

</center>
<a name="conclusions"></a>**Conclusions**

The comparisons of hot-to-cold engine maps showed that a constant
adjustment factor over the entire speed-torque maps results in erroneous
predictions. The graphs above (Figure 1 through Figure 14) show that the
cold-to-hot ratios can vary substantially through the torque-speed map.

<p>
Table 1 shows the Cold-to-Hot factors in the current ADVISOR model and
the range shown by the data. \
  \
  \

<center>
<p>
<a name="_Ref505510243"></a>**Table 1: Correction Factors–ADVISOR
Predictions and Data Ranges**

</center>
<center>
<table border cellpadding="7" width="507">
<tr>
<td valign="TOP" width="19%" height="19">
<center>
**Parameter**

</center>
</td>
<td valign="TOP" colspan="2" width="34%" height="19">
<center>
**ADVISOR Factor**

</center>
</td>
<td valign="TOP" colspan="2" width="47%" height="19">
<center>
**Factor Range from Data**

</center>
</td>
</tr>
<tr>
<td valign="TOP" width="19%" height="19">
</td>
<td valign="TOP" width="18%" height="19">
<center>
*VW*

</center>
</td>
<td valign="TOP" width="16%" height="19">
<center>
*MB*

</center>
</td>
<td valign="TOP" width="24%" height="19">
<center>
*VW*

</center>
</td>
<td valign="TOP" width="23%" height="19">
<center>
*MB*

</center>
</td>
</tr>
<tr>
<td valign="TOP" width="19%" height="19">
<center>
*Fuel Use*

</center>
</td>
<td valign="TOP" width="18%" height="19">
<center>
1.95

</center>
</td>
<td valign="TOP" width="16%" height="19">
<center>
1.58

</center>
</td>
<td valign="TOP" width="24%" height="19">
<center>
0.9-1.3

</center>
</td>
<td valign="TOP" width="23%" height="19">
<center>
1.03-1.3

</center>
</td>
</tr>
<tr>
<td valign="TOP" width="19%" height="19">
<center>
*HC*

</center>
</td>
<td valign="TOP" width="18%" height="19">
<center>
8

</center>
</td>
<td valign="TOP" width="16%" height="19">
<center>
5.29

</center>
</td>
<td valign="TOP" width="24%" height="19">
<center>
0.5-50

</center>
</td>
<td valign="TOP" width="23%" height="19">
<center>
1.25-4

</center>
</td>
</tr>
<tr>
<td valign="TOP" width="19%" height="19">
<center>
*CO*

</center>
</td>
<td valign="TOP" width="18%" height="19">
<center>
10

</center>
</td>
<td valign="TOP" width="16%" height="19">
<center>
6.32

</center>
</td>
<td valign="TOP" width="24%" height="19">
<center>
0.5-7

</center>
</td>
<td valign="TOP" width="23%" height="19">
<center>
1-3

</center>
</td>
</tr>
<tr>
<td valign="TOP" width="19%" height="19">
<center>
*NOx*

</center>
</td>
<td valign="TOP" width="18%" height="19">
<center>
1.5

</center>
</td>
<td valign="TOP" width="16%" height="19">
<center>
1.16

</center>
</td>
<td valign="TOP" width="24%" height="19">
<center>
0.25-2.5

</center>
</td>
<td valign="TOP" width="23%" height="19">
<center>
0.8-2.2

</center>
</td>
</tr>
<tr>
<td valign="TOP" width="19%" height="19">
<center>
*PM*

</center>
</td>
<td valign="TOP" width="18%" height="19">
<center>
8

</center>
</td>
<td valign="TOP" width="16%" height="19">
<center>
5.29

</center>
</td>
<td valign="TOP" width="24%" height="19">
<center>
1-20

</center>
</td>
<td valign="TOP" width="23%" height="19">
<center>
1-2.5

</center>
</td>
</tr>
<tr>
<td valign="TOP" width="19%" height="19">
<center>
*Exhaust Temperature*

</center>
</td>
<td valign="TOP" width="18%" height="19">
<center>
N/A

</center>
</td>
<td valign="TOP" width="16%" height="19">
<center>
N/A

</center>
</td>
<td valign="TOP" width="24%" height="19">
<center>
0.6-1.6

</center>
</td>
<td valign="TOP" width="23%" height="19">
<center>
0.8-0.95

</center>
</td>
</tr>
<tr>
<td valign="TOP" width="19%" height="19">
<center>
*Exhaust Flow*

</center>
</td>
<td valign="TOP" width="18%" height="19">
<center>
N/A

</center>
</td>
<td valign="TOP" width="16%" height="19">
<center>
N/A

</center>
</td>
<td valign="TOP" width="24%" height="19">
<center>
1-1.3

</center>
</td>
<td valign="TOP" width="23%" height="19">
<center>
1-1.3

</center>
</td>
</tr>
</table>
</center>
This shows that ADVISOR is currently over predicting cold fuel use and
CO emissions. HC, NOx, and PM emissions are over predicted for a
majority of the operating points on the maps, but may be under predicted
in other areas. Additionally, some emissions (e.g. NOx) showed lower
emissions at cold temperatures than hot. ADVISOR’s constant adjustment
factors do not drop below one, such that this type of behavior is
unaccounted for. \
 

<a name="new ADV corr factors"></a>**<font size="+1">New ADVISOR
Cold-to-Hot Engine Map Correction Factors</font>**

To address these differences between the data and the current
cold-to-hot usage model in ADVISOR, three options were explored.

1.  Change ADVISOR’s constant adjustment factor to be an average of that
    shown by the data.
2.  Change the model to have the factor vary with both torque and speed.
    This could involve sectioning out the maps into similar areas, each
    with a constant factor, or creating an equation to define the factor
    based on torque and speed.
3.  Have the user input cold maps (one or more) when available and
    interpolate between the available maps.

Of the three options, options 2 and 3 are the most comprehensive. Option
1 was explored as a simple baseline case to increase the accuracy of
ADVISOR while development on the other two occurred.

<p>
<a name="op1"></a>**Option 1: Change the values of ADVISOR’s Cold-Hot
Adjustment Factors** \
The form of the equation (see Equation 2) relating cold engine outputs
to hot outputs was assumed to be the same, and the variable parameters
were updated. As a reminder, the form is as follows:

<center>
<p>
![](Image105.gif) Eqn 3

</center>
<p>
Updated values for *Coeff* and *Exponent* could be obtained by assuming
a constant *factor* by using the factor maps available for two different
<font face="Symbol">l</font> values (VW:<font face="Symbol">
l</font>=0.985 MB: <font face="Symbol">l</font>=0.837). In order to have
a first-pass guess at which *factor* values to assume from the maps, a
simple simulation of a conventional vehicle over the FTP was performed
(default conventional with ADVISOR 3.1 with the FC\_CI60\_emis engine
chosen). The locus of operating points on the engine is shown in Figure
15. A large majority of the points lie below 2500 rpm and 100 Nm, with a
concentration below 1500 rpm and 50 Nm. Of course this will vary with
the chosen shift schedule, but this behavior was taken as
representative.

<center>
![](Image106.gif)

<p>
<a name="_Ref505509745"></a>**Figure 15: Engine Operating Points on an
FTP Cycle**

</center>
<p>
Table 2 shows the assumed values for the *factors* and the resulting
values for the *Coeff*and *Exponent* in Equation 3. The ‘previous’
values for *Coeff*and *Exponen*are also shown for reference.

<center>
<p>
<a name="_Ref505510299"></a>**Table 2: Assumed Correction Factors,
Updated and Previous Coeff’s and Exponents**

</center>
<center>
<table border cellpadding="2" width="520">
<tr>
<td valign="TOP" width="10%" height="17">
</td>
<td valign="TOP" colspan="3" width="23%" height="17">
<center>
**<u><font face="Arial"><font size="-1">Factor from
Data</font></font></u>**

</center>
</td>
<td valign="TOP" colspan="2" width="21%" height="17">
<center>
**<u><font face="Arial"><font size="-1">Previous
Factor</font></font></u>**

</center>
</td>
<td valign="TOP" colspan="2" width="25%" height="17">
<center>
**<u><font face="Arial"><font size="-1">Updated </font></font></u>**

</center>
</td>
<td valign="TOP" colspan="2" width="21%" height="17">
**<u><font face="Arial"><font size="-1">Previous</font></font></u>**

</td>
</tr>
<tr>
<td valign="TOP" colspan="2" width="13%" height="17">
</td>
<td valign="TOP" width="9%" height="17">
<center>
**<u><font face="Arial"><font size="-1">VW</font></font></u>**

</center>
</td>
<td valign="TOP" width="11%" height="17">
<center>
**<u><font face="Arial"><font size="-1">MB</font></font></u>**

</center>
</td>
<td valign="TOP" width="10%" height="17">
<center>
**<u><font face="Arial"><font size="-1">VW</font></font></u>**

</center>
</td>
<td valign="TOP" width="11%" height="17">
<center>
**<u><font face="Arial"><font size="-1">MB</font></font></u>**

</center>
</td>
<td valign="TOP" width="12%" height="17">
<center>
**<u><font face="Arial"><font size="-1">Coeff</font></font></u>**

</center>
</td>
<td valign="TOP" width="14%" height="17">
<center>
**<u><font face="Arial"><font size="-1">Exponent</font></font></u>**

</center>
</td>
<td valign="TOP" width="8%" height="17">
<center>
**<u><font face="Arial"><font size="-1">Coeff</font></font></u>**

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
**<u><font face="Arial"><font size="-1">Exponent</font></font></u>**

</center>
</td>
</tr>
<tr>
<td valign="TOP" colspan="2" width="13%" height="17">
**<font face="Arial"><font size="-1">lambda</font></font>**

</td>
<td valign="TOP" width="9%" height="17">
<center>
<font face="Arial"><font size="-1">0.985</font></font>

</center>
</td>
<td valign="TOP" width="11%" height="17">
<center>
<font face="Arial"><font size="-1">0.837</font></font>

</center>
</td>
<td valign="TOP" width="10%" height="17">
</td>
<td valign="TOP" width="11%" height="17">
</td>
<td valign="TOP" width="12%" height="17">
</td>
<td valign="TOP" width="14%" height="17">
</td>
<td valign="TOP" width="8%" height="17">
</td>
<td valign="TOP" width="13%" height="17">
</td>
</tr>
<tr>
<td valign="TOP" colspan="2" width="13%" height="17">
**<font face="Arial"><font size="-1">Fuel</font></font>**

</td>
<td valign="TOP" width="9%" height="17">
<center>
<font face="Arial"><font size="-1">1.1</font></font>

</center>
</td>
<td valign="TOP" width="11%" height="17">
<center>
<font face="Arial"><font size="-1">1.09</font></font>

</center>
</td>
<td valign="TOP" width="10%" height="17">
<center>
<font face="Arial"><font size="-1">1.95</font></font>

</center>
</td>
<td valign="TOP" width="11%" height="17">
<center>
<font face="Arial"><font size="-1">1.58</font></font>

</center>
</td>
<td valign="TOP" width="12%" height="17" bgcolor="#FFFF00">
<center>
<font face="Arial"><font size="-1">0.10</font></font>

</center>
</td>
<td valign="TOP" width="14%" height="17" bgcolor="#FFFF00">
<center>
<font face="Arial"><font size="-1">0.65</font></font>

</center>
</td>
<td valign="TOP" width="8%" height="17">
<center>
<font face="Arial"><font size="-1">1</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">3.1</font></font>

</center>
</td>
</tr>
<tr>
<td valign="TOP" colspan="2" width="13%" height="17">
**<font face="Arial"><font size="-1">HC</font></font>**

</td>
<td valign="TOP" width="9%" height="17">
<center>
<font face="Arial"><font size="-1">8</font></font>

</center>
</td>
<td valign="TOP" width="11%" height="17">
<center>
<font face="Arial"><font size="-1">2.5</font></font>

</center>
</td>
<td valign="TOP" width="10%" height="17">
<center>
<font face="Arial"><font size="-1">8.07</font></font>

</center>
</td>
<td valign="TOP" width="11%" height="17">
<center>
<font face="Arial"><font size="-1">5.3</font></font>

</center>
</td>
<td valign="TOP" width="12%" height="17" bgcolor="#FFFF00">
<center>
<font face="Arial"><font size="-1">8.05</font></font>

</center>
</td>
<td valign="TOP" width="14%" height="17" bgcolor="#FFFF00">
<center>
<font face="Arial"><font size="-1">9.46</font></font>

</center>
</td>
<td valign="TOP" width="8%" height="17">
<center>
<font face="Arial"><font size="-1">7.4</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">3.072</font></font>

</center>
</td>
</tr>
<tr>
<td valign="TOP" colspan="2" width="13%" height="17">
**<font face="Arial"><font size="-1">CO</font></font>**

</td>
<td valign="TOP" width="9%" height="17">
<center>
<font face="Arial"><font size="-1">3</font></font>

</center>
</td>
<td valign="TOP" width="11%" height="17">
<center>
<font face="Arial"><font size="-1">2</font></font>

</center>
</td>
<td valign="TOP" width="10%" height="17">
<center>
<font face="Arial"><font size="-1">9.96</font></font>

</center>
</td>
<td valign="TOP" width="11%" height="17">
<center>
<font face="Arial"><font size="-1">6.3</font></font>

</center>
</td>
<td valign="TOP" width="12%" height="17" bgcolor="#FFFF00">
<center>
<font face="Arial"><font size="-1">2.13</font></font>

</center>
</td>
<td valign="TOP" width="14%" height="17" bgcolor="#FFFF00">
<center>
<font face="Arial"><font size="-1">4.26</font></font>

</center>
</td>
<td valign="TOP" width="8%" height="17">
<center>
<font face="Arial"><font size="-1">9.4</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">3.21</font></font>

</center>
</td>
</tr>
<tr>
<td valign="TOP" colspan="2" width="13%" height="17">
**<font face="Arial"><font size="-1">NOx</font></font>**

</td>
<td valign="TOP" width="9%" height="17">
<center>
<font face="Arial"><font size="-1">1.5</font></font>

</center>
</td>
<td valign="TOP" width="11%" height="17">
<center>
<font face="Arial"><font size="-1">1.4</font></font>

</center>
</td>
<td valign="TOP" width="10%" height="17">
<center>
<font face="Arial"><font size="-1">1.54</font></font>

</center>
</td>
<td valign="TOP" width="11%" height="17">
<center>
<font face="Arial"><font size="-1">1.16</font></font>

</center>
</td>
<td valign="TOP" width="12%" height="17" bgcolor="#FFFF00">
<center>
<font face="Arial"><font size="-1">0.51</font></font>

</center>
</td>
<td valign="TOP" width="14%" height="17" bgcolor="#FFFF00">
<center>
<font face="Arial"><font size="-1">1.37</font></font>

</center>
</td>
<td valign="TOP" width="8%" height="17">
<center>
<font face="Arial"><font size="-1">0.6</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">7.3</font></font>

</center>
</td>
</tr>
<tr>
<td valign="TOP" colspan="2" width="13%" height="17">
**<font face="Arial"><font size="-1">PM</font></font>**

</td>
<td valign="TOP" width="9%" height="17">
<center>
<font face="Arial"><font size="-1">5</font></font>

</center>
</td>
<td valign="TOP" width="11%" height="17">
<center>
<font face="Arial"><font size="-1">1.25</font></font>

</center>
</td>
<td valign="TOP" width="10%" height="17">
<center>
<font face="Arial"><font size="-1">8.07</font></font>

</center>
</td>
<td valign="TOP" width="11%" height="17">
<center>
<font face="Arial"><font size="-1">5.3</font></font>

</center>
</td>
<td valign="TOP" width="12%" height="17" bgcolor="#FFFF00">
<center>
<font face="Arial"><font size="-1">5.14</font></font>

</center>
</td>
<td valign="TOP" width="14%" height="17" bgcolor="#FFFF00">
<center>
<font face="Arial"><font size="-1">17.04</font></font>

</center>
</td>
<td valign="TOP" width="8%" height="17">
<center>
<font face="Arial"><font size="-1">7.4</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">3.072</font></font>

</center>
</td>
</tr>
</table>
</center>
The following points were noted in the assumed values for each factor:

-   Fuel: in the locus area (from Figure 15), the fuel factor is
    approximately linear with increasing speed.
-   HC: assuming a constant factor is not a very good approximation.
-   CO: the CO factor behaves approximately linear with increasing speed
    and increasing torque
-   NOx: *factor* islands exist in the locus area, assuming a constant
    factor across the map is not a good approximation here.
-   PM: the PM factor behaves approximately linear with increasing speed
    and increasing torque, again a single factor is not a good
    approximation for PM, as the value dramatically increases at low
    speeds and low torques.

The notes for each parameter show that this approach, while an
improvement over the previous values listed in ADVISOR, are still not
very accurate.

<a name="op2"></a>**Option 2: Correction Factors as Functions of Speed
and Torque, in addition to Temperature through <font face="Symbol">l,
</font>Map Fits Based on Trends** \
The implementation of correction factor maps was postponed until
implementation of Option 3.

<a name="op3"></a>**Option 3: Cold Maps Input by User** \
The user has the ability to enter cold engine maps, if the data is
available. The two engines tested at ORNL have their maps available in
ADVISOR (FC\_CI60\_emis for the Mercedes engine and FC\_CI67\_emis for
the Volkswagen engine).

<p>
The engine input m-files have new variables denoted by \*\_cold for cold
maps (e.g. fc\_fuel\_map\_cold). These are processed to determine a
cold-to-hot ratio map denoted by \*\_c2h (e.g. fc\_fuel\_map\_c2h).
These ratios and the temperature of the cold testing (fc\_cold\_tmp) are
used to determine the cold use by the following equation (a linear
relationship between the temperature and change in use is assumed):

<center>
<p>
![](Image107.gif)              Eqn 4

</center>
<p>
Simulations were run on a conventional vehicle to determine the effect
of using the map-based approach (Option 3) instead of the constant ratio
equation-based approach (Option 1). A default conventional vehicle with
the VW and then the MB engine was ran over a cold FTP cycle. Note: to
select the ‘equation’ correction (based on Equation 3), set the variable
fc\_cold=0, and to select the ‘cold map’ correction option. Table 3
shows the large differences that can be seen in the different
approaches. Using the map-based approach had a 1-2% effect on fuel
economy, and up to 53% effect on emissions. Using the cold maps for
interpolation is much more accurate than the equation-based approach.

<center>
<p>
<a name="_Ref505595160"></a>**Table 3: Equation vs. Map Based Cold
Corrections over an FTP**

</center>
<center>
<table border cellpadding="2" width="520">
<tr>
<td valign="TOP" width="18%" height="17">
</td>
<td valign="TOP" width="17%" height="17">
</td>
<td valign="TOP" width="13%" height="17">
<center>
**<font face="Arial"><font size="-1">MPG</font></font>**

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
**<font face="Arial"><font size="-1">HC</font></font>**

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
**<font face="Arial"><font size="-1">CO</font></font>**

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
**<font face="Arial"><font size="-1">NOx</font></font>**

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
**<font face="Arial"><font size="-1">PM</font></font>**

</center>
</td>
</tr>
<tr>
<td valign="TOP" width="18%" height="17">
**<font face="Arial"><font size="-1">Volkswagen</font></font>**

</td>
<td valign="TOP" width="17%" height="17">
**<font face="Arial"><font size="-1">Equation</font></font>**

</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">44.4</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">0.349</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">1.751</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">0.734</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">0.049</font></font>

</center>
</td>
</tr>
<tr>
<td valign="TOP" width="18%" height="17">
</td>
<td valign="TOP" width="17%" height="17">
**<font face="Arial"><font size="-1">Cold Map</font></font>**

</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">44.8</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">0.731</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">2.321</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">0.698</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">0.065</font></font>

</center>
</td>
</tr>
<tr>
<td valign="TOP" width="18%" height="17">
</td>
<td valign="TOP" width="17%" height="17">
**<font face="Arial"><font size="-1">% difference</font></font>**

</td>
<td valign="TOP" width="13%" height="17" bgcolor="#FFFF99">
<center>
<font face="Arial"><font size="-1">0.9%</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17" bgcolor="#FFFF99">
<center>
<font face="Arial"><font size="-1">52.3%</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17" bgcolor="#FFFF99">
<center>
<font face="Arial,Helvetica"><font color="#000000"><font size="-1">24.6%</font></font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17" bgcolor="#FFFF99">
<center>
<font face="Arial,Helvetica"><font color="#000000"><font size="-1">-5.2%</font></font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17" bgcolor="#FFFF99">
<center>
<font face="Arial,Helvetica"><font color="#000000"><font size="-1">24.6%</font></font></font>

</center>
</td>
</tr>
<tr>
<td valign="TOP" width="18%" height="17">
**<font face="Arial"><font size="-1">Mercedes</font></font>**

</td>
<td valign="TOP" width="17%" height="17">
**<font face="Arial"><font size="-1">Equation</font></font>**

</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">46.1</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">0.609</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">1.812</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">1.027</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">0.073</font></font>

</center>
</td>
</tr>
<tr>
<td valign="TOP" width="18%" height="17">
</td>
<td valign="TOP" width="17%" height="17">
**<font face="Arial"><font size="-1">Cold Map</font></font>**

</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">45.1</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">0.63</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">2.106</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">0.927</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17">
<center>
<font face="Arial"><font size="-1">0.061</font></font>

</center>
</td>
</tr>
<tr>
<td valign="TOP" width="18%" height="17">
</td>
<td valign="TOP" width="17%" height="17">
**<font face="Arial"><font size="-1">% difference</font></font>**

</td>
<td valign="TOP" width="13%" height="17" bgcolor="#FFFF99">
<center>
<font face="Arial"><font size="-1">-2.2%</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17" bgcolor="#FFFF99">
<center>
<font face="Arial"><font size="-1">3.3%</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17" bgcolor="#FFFF99">
<center>
<font face="Arial"><font size="-1">14.0%</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17" bgcolor="#FFFF99">
<center>
<font face="Arial"><font size="-1">-10.8%</font></font>

</center>
</td>
<td valign="TOP" width="13%" height="17" bgcolor="#FFFF99">
<center>
<font face="Arial"><font size="-1">-19.7%</font></font>

</center>
</td>
</tr>
<tr>
<td valign="TOP" width="18%" height="17">
<div align="right">
<font face="Arial"><font size="-1">\* Simulation:</font></font>

</div>
</td>
<td valign="TOP" colspan="4" width="56%" height="17">
<font face="Arial"><font size="-1">Conventional default, then engines
specified,</font></font>

</td>
<td valign="TOP" width="13%" height="17">
</td>
<td valign="TOP" width="13%" height="17">
</td>
</tr>
<tr>
<td valign="TOP" width="18%" height="7">
</td>
<td valign="TOP" colspan="3" width="43%" height="7">
<font face="Arial"><font size="-1">cold FTP cycle (not test
procedure)</font></font>

</td>
<td valign="TOP" width="13%" height="7">
</td>
<td valign="TOP" width="13%" height="7">
</td>
<td valign="TOP" width="13%" height="7">
</td>
</tr>
</table>
</center>

* * * * *

<center>
[Back to Chapter 3](advisor_ch3.html)

</center>
Last Revised: 02/01/01: VHJ
